<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

$success = false;
$error = '';

// Handle form submission for adding a new service
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $price = trim($_POST['price'] ?? '');
    $features = trim($_POST['features'] ?? '');
    $popular = isset($_POST['popular']) ? 1 : 0;
    $category = trim($_POST['category'] ?? '');
    $gradient = trim($_POST['gradient'] ?? '');
    $icon = trim($_POST['icon'] ?? '');

    if (empty($title) || empty($price) || empty($category)) {
        $error = 'يرجى ملء الحقول المطلوبة (الاسم، السعر، الفئة).';
    } else {
        try {
            $conn = getAdminDBConnection();

            $stmt = $conn->prepare("INSERT INTO services (title, description, price, features, popular, category, gradient, icon, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
            if ($stmt === false) {
                throw new Exception('Prepare statement failed: ' . $conn->error);
            }

            // Bind parameters based on their types
            // s: string, d: double, i: integer
            $stmt->bind_param('ssdssiss', $title, $description, $price, $features, $popular, $category, $gradient, $icon);

            if ($stmt->execute()) {
                $message = 'تم إضافة الخدمة بنجاح!';
                $message_type = 'success';
                header('Location: admin_services.php?message=' . urlencode($message) . '&type=' . $message_type);
                exit();
            } else {
                $error = 'حدث خطأ أثناء إضافة الخدمة: ' . $conn->error;
            }
            $stmt->close();
        } catch (Exception $e) {
            $error = 'خطأ: ' . $e->getMessage();
        }
    }
}

require_once '../header.php'; // Include header for consistent styling
?>

<div class="container bg-dark text-white mt-5">
    <div class="card">
        <div class="card-header">
            <h3 class="mb-0">إضافة خدمة جديدة</h3>
        </div>
        <div class="card-body">
            <?php if ($success): ?>
                <div class="alert alert-success" role="alert">تم إضافة الخدمة بنجاح!</div>
            <?php elseif ($error): ?>
                <div class="alert alert-danger" role="alert">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="mb-3">
                    <label for="title" class="form-label">اسم الخدمة <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?= htmlspecialchars($_POST['title'] ?? '') ?>" required>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">الوصف</label>
                    <textarea class="form-control" id="description" name="description" rows="3"><?= htmlspecialchars($_POST['description'] ?? '') ?></textarea>
                </div>
                <div class="mb-3">
                    <label for="price" class="form-label">السعر <span class="text-danger">*</span></label>
                    <input type="number" step="0.01" class="form-control" id="price" name="price" value="<?= htmlspecialchars($_POST['price'] ?? '') ?>" required>
                </div>
                <div class="mb-3">
                    <label for="features" class="form-label">المميزات (افصلها بفاصلة)</label>
                    <input type="text" class="form-control" id="features" name="features" value="<?= htmlspecialchars($_POST['features'] ?? '') ?>">
                </div>
                <div class="mb-3 form-check">
                    <input type="checkbox" class="form-check-input" id="popular" name="popular" <?= isset($_POST['popular']) ? 'checked' : '' ?>>
                    <label class="form-check-label" for="popular">شائع</label>
                </div>
                <div class="mb-3">
                    <label for="category" class="form-label">الفئة <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="category" name="category" value="<?= htmlspecialchars($_POST['category'] ?? '') ?>" required>
                </div>
                 <div class="mb-3">
                    <label for="gradient" class="form-label">التدرج اللوني (Gradient)</label>
                    <input type="text" class="form-control" id="gradient" name="gradient" placeholder="مثال: linear-gradient(90deg, #e14eca 0%, #7367f0 100%)" value="<?= htmlspecialchars($_POST['gradient'] ?? '') ?>">
                </div>
                <div class="mb-3">
                    <label for="icon" class="form-label">أيقونة (Bootstrap Icon Class)</label>
                    <input type="text" class="form-control" id="icon" name="icon" placeholder="مثال: bi-facebook" value="<?= htmlspecialchars($_POST['icon'] ?? '') ?>">
                </div>
                <button type="submit" class="btn btn-primary">إضافة الخدمة</button>
                <a href="admin_services.php" class="btn btn-secondary">إلغاء</a>
            </form>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?> 